<?php
session_start();
include('../config/db_connect.php');

if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}

$message = "";

if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $class_name = trim($_POST['class_name']);

    if(!empty($class_name)){
        $query = "INSERT INTO classes (class_name) VALUES ('$class_name')";
        if(mysqli_query($conn, $query)){
            $message = "✅ Class added successfully!";
        } else {
            $message = "❌ Error adding class!";
        }
    } else {
        $message = "⚠️ Class name cannot be empty!";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Class</title>

    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #075d8a, #0a9edb);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            background: rgba(255,255,255,0.15);
            padding: 35px;
            border-radius: 12px;
            width: 380px;
            text-align: center;
            backdrop-filter: blur(12px);
            color: white;
        }

        .container h2 {
            margin-bottom: 20px;
        }

        input {
            width: 90%;
            padding: 10px;
            border-radius: 6px;
            border: none;
            outline: none;
            margin-top: 10px;
            font-size: 15px;
        }

        button {
            width: 95%;
            padding: 10px;
            background: white;
            border: none;
            color: #075d8a;
            font-weight: bold;
            border-radius: 6px;
            margin-top: 20px;
            cursor: pointer;
            transition: 0.3s;
        }

        button:hover {
            background: #f0f0f0;
        }

        .message {
            margin-top: 15px;
            font-size: 14px;
            font-weight: bold;
        }

        a {
            display: inline-block;
            margin-top: 20px;
            color: #fff;
            text-decoration: none;
            opacity: 0.85;
        }

        a:hover {
            opacity: 1;
        }
    </style>

</head>
<body>

<div class="container">
    <h2>Add Class</h2>

    <form method="POST">
        <input type="text" name="class_name" placeholder="e.g., Grade 8" required>
        <button type="submit">➕ Save Class</button>
    </form>

    <?php if($message){ ?>
        <p class="message"><?php echo $message; ?></p>
    <?php } ?>

    <a href="dashboard.php">⬅ Back to Dashboard</a>
</div>

</body>
</html>
