<?php
session_start();
include('../config/db_connect.php');

if (!isset($_SESSION['admin'])) {
    header("Location: index.php");
    exit;
}

$message = "";

// Fetch departments
$departments = mysqli_query($conn, "SELECT * FROM departments ORDER BY dept_name ASC");

if ($_SERVER['REQUEST_METHOD'] == "POST") {

    $full_name = trim($_POST['full_name']);
    $username  = trim($_POST['username']);
    $password  = trim($_POST['password']);
    $dept_id   = intval($_POST['dept_id']);

    if ($full_name && $username && $password && $dept_id) {

        // Save password as plain text (as requested)
        $stmt = $conn->prepare("INSERT INTO hods (full_name, username, password, dept_id) 
                                VALUES (?,?,?,?)");
        $stmt->bind_param("sssi", $full_name, $username, $password, $dept_id);

        if ($stmt->execute()) {
            $message = "✅ HOD added successfully!";
        } else {
            $message = "❌ Error: Username already exists.";
        }

        $stmt->close();

    } else {
        $message = "⚠️ All fields are required!";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Add HOD</title>
<style>
    body {
        margin: 0;
        font-family: Poppins, sans-serif;
        background: linear-gradient(135deg, #075d8a, #0a9edb);
        height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        color: white;
    }

    .container {
        background: rgba(255,255,255,0.15);
        backdrop-filter: blur(10px);
        padding: 30px;
        width: 420px;
        border-radius: 12px;
        text-align: center;
    }

    input, select {
        width: 90%;
        padding: 10px;
        margin-top: 12px;
        border-radius: 6px;
        border: none;
        outline: none;
        font-size: 15px;
    }

    button {
        width: 95%;
        padding: 12px;
        margin-top: 20px;
        background: #fff;
        color: #075d8a;
        border: none;
        font-weight: bold;
        border-radius: 6px;
        cursor: pointer;
        transition: .3s;
    }

    button:hover {
        background: #e8e8e8;
    }

    .message {
        margin-top: 15px;
        font-weight: bold;
    }

    a {
        margin-top: 25px;
        display: inline-block;
        color: white;
        opacity: 0.8;
        text-decoration: none;
        font-size: 14px;
    }

    a:hover {
        opacity: 1;
    }
</style>
</head>

<body>

<div class="container">
    <h2>Add HOD</h2>

    <form method="POST">

        <input type="text" name="full_name" placeholder="HOD Full Name" required>

        <input type="text" name="username" placeholder="Create Username" required>

        <input type="password" name="password" placeholder="Create Password" required>

        <select name="dept_id" required>
            <option value="">-- Select Department --</option>
            <?php while ($row = mysqli_fetch_assoc($departments)) { ?>
                <option value="<?= $row['dept_id']; ?>">
                    <?= $row['dept_name']; ?>
                </option>
            <?php } ?>
        </select>

        <button type="submit">➕ Save HOD</button>
    </form>

    <?php if (!empty($message)) { ?>
        <p class="message"><?= $message ?></p>
    <?php } ?>

    <a href="dashboard.php">⬅ Back to Dashboard</a>
</div>

</body>
</html>
