<?php
session_start();
include('../config/db_connect.php');

// Redirect if not logged in
if (!isset($_SESSION['admin'])) {
    header("Location: index.php");
    exit;
}

$message = "";

// Fetch classes
$classes = mysqli_query($conn, "SELECT * FROM classes ORDER BY class_name ASC");

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $full_name = trim($_POST['full_name']);
    $gender    = $_POST['gender'];
    $class_id  = $_POST['class_id'];

    if ($full_name && $gender && $class_id) {

        // Use prepared statement for security
        $stmt = $conn->prepare("INSERT INTO students (full_name, gender, class_id) VALUES (?, ?, ?)");
        $stmt->bind_param("ssi", $full_name, $gender, $class_id);

        if ($stmt->execute()) {
            $message = "✅ Student added successfully!";
        } else {
            $message = "❌ Error adding student!";
        }

        $stmt->close();
    } else {
        $message = "⚠️ All fields are required!";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Student</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #075d8a, #0a9edb);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            background: rgba(255,255,255,0.15);
            backdrop-filter: blur(12px);
            padding: 35px;
            border-radius: 12px;
            width: 420px;
            text-align: center;
            color: #fff;
        }

        h2 { margin-bottom: 20px; }

        input, select {
            width: 90%;
            padding: 10px;
            margin-top: 12px;
            border: none;
            border-radius: 6px;
            outline: none;
            font-size: 15px;
        }

        button {
            width: 95%;
            padding: 12px;
            margin-top: 25px;
            background: #fff;
            color: #075d8a;
            font-weight: bold;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            transition: 0.3s;
        }

        button:hover { background: #e7e7e7; }

        .message {
            margin-top: 15px;
            font-size: 14px;
            font-weight: bold;
        }

        a {
            display: inline-block;
            margin-top: 25px;
            color: #fff;
            opacity: 0.85;
            text-decoration: none;
        }

        a:hover { opacity: 1; }
    </style>
</head>
<body>

<div class="container">
    <h2>Add Student</h2>

    <form method="POST">
        <input type="text" name="full_name" placeholder="Student Full Name" required>

        <select name="gender" required>
            <option value="">-- Select Gender --</option>
            <option value="Male">Male</option>
            <option value="Female">Female</option>
        </select>

        <select name="class_id" required>
            <option value="">-- Select Class --</option>
            <?php while ($row = mysqli_fetch_assoc($classes)) : ?>
                <option value="<?= $row['class_id']; ?>"><?= $row['class_name']; ?></option>
            <?php endwhile; ?>
        </select>

        <button type="submit">➕ Save Student</button>
    </form>

    <?php if ($message) : ?>
        <p class="message"><?= $message; ?></p>
    <?php endif; ?>

    <a href="dashboard.php">⬅ Back to Dashboard</a>
</div>

</body>
</html>
