<?php
session_start();
include('../config/db_connect.php');

if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}

$message = "";

// Fetch class list for dropdown
$classes = mysqli_query($conn, "SELECT * FROM classes ORDER BY class_name ASC");

if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $full_name = trim($_POST['full_name']);
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    $class_id = $_POST['class_id'];

    if($full_name && $username && $password && $class_id){

        // ⚠️ Save password as plain text (no hashing)
        $stmt = $conn->prepare("INSERT INTO teachers (full_name, username, password, class_id) VALUES (?,?,?,?)");
        $stmt->bind_param("sssi", $full_name, $username, $password, $class_id);

        if($stmt->execute()){
            $message = "✅ Teacher added successfully!";
        } else {
            $message = "❌ Error: Username may already exist.";
        }

        $stmt->close();
    } else {
        $message = "⚠️ All fields are required!";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Teacher</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #075d8a, #0a9edb);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            background: rgba(255,255,255,0.15);
            backdrop-filter: blur(12px);
            padding: 35px;
            border-radius: 12px;
            width: 420px;
            text-align: center;
            color: #fff;
        }

        h2 { margin-bottom: 20px; }

        input, select {
            width: 90%;
            padding: 10px;
            border-radius: 6px;
            border: none;
            outline: none;
            margin-top: 12px;
            font-size: 15px;
        }

        button {
            width: 95%;
            padding: 12px;
            margin-top: 25px;
            background: #fff;
            border-radius: 6px;
            border: none;
            color: #075d8a;
            font-weight: bold;
            cursor: pointer;
            transition: 0.3s;
        }

        button:hover { background: #e7e7e7; }

        .message {
            margin-top: 15px;
            font-size: 14px;
            font-weight: bold;
        }

        a {
            display: inline-block;
            margin-top: 25px;
            color: #fff;
            opacity: 0.85;
            text-decoration: none;
        }

        a:hover { opacity: 1; }
    </style>
</head>
<body>

<div class="container">
    <h2>Add Teacher</h2>

    <form method="POST">

        <input type="text" name="full_name" placeholder="Teacher Full Name" required>

        <input type="text" name="username" placeholder="Create Username" required>

        <input type="password" name="password" placeholder="Create Password" required>

        <select name="class_id" required>
            <option value="">-- Assign Class --</option>
            <?php while($row = mysqli_fetch_assoc($classes)){ ?>
                <option value="<?php echo $row['class_id']; ?>">
                    <?php echo $row['class_name']; ?>
                </option>
            <?php } ?>
        </select>

        <button type="submit">➕ Save Teacher</button>
    </form>

    <?php if($message){ ?>
        <p class="message"><?php echo $message; ?></p>
    <?php } ?>

    <a href="dashboard.php">⬅ Back to Dashboard</a>
</div>

</body>
</html>
