<?php
session_start();
include('../config/db_connect.php');

// Allow Admin or HOD to view
if (!isset($_SESSION['admin']) && !isset($_SESSION['hod_id'])) {
    header("Location: ../index.php");
    exit;
}

// Fetch uploads from all HODs
$q = mysqli_query($conn, "
    SELECT u.*, h.full_name AS hod_name
    FROM hod_uploads u
    LEFT JOIN hod h ON u.hod_id = h.hod_id
    ORDER BY upload_id DESC
");
?>
<!DOCTYPE html>
<html>
<head>
<title>HOD Uploaded Tests</title>

<style>
    body {
        background: #f2f5ff;
        font-family: Poppins, sans-serif;
    }

    .container {
        width: 90%;
        margin: 30px auto;
    }

    h2 {
        color: #0a4fa3;
        margin-bottom: 20px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0,0,0,0.12);
    }

    th {
        background: #0a4fa3;
        color: white;
        padding: 14px;
        font-size: 16px;
    }

    td {
        padding: 12px;
        border-bottom: 1px solid #ddd;
    }

    tr:hover {
        background: #f5f8ff;
    }

    a.download {
        color: #0060ff;
        font-weight: bold;
    }

    a.delete {
        color: red;
        font-weight: bold;
    }
</style>
</head>

<body>

<div class="container">
    <h2>HOD Uploaded Tests</h2>

    <table>
        <tr>
            <th>Subject</th>
            <th>Teacher</th>
            <th>HOD</th>
            <th>File</th>
            <th>Uploaded On</th>
            <th>Download</th>
            <th>Delete</th>
        </tr>

        <?php while ($u = mysqli_fetch_assoc($q)): ?>
        <tr>
            <td><?= htmlspecialchars($u['subject']) ?></td>
            <td><?= htmlspecialchars($u['teacher_name']) ?></td>
            <td><?= htmlspecialchars($u['hod_name']) ?></td>
            <td><?= htmlspecialchars($u['original_name']) ?></td>
            <td><?= date("d M Y H:i", strtotime($u['upload_date'])) ?></td>

            <td>
                <a class="download"
                   href="../<?= $u['file_name'] ?>"
                   download>Download</a>
            </td>

            <td>
                <a class="delete"
                   href="delete_upload.php?id=<?= $u['upload_id'] ?>"
                   onclick="return confirm('Delete this file?');">
                   Delete
                </a>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>
</div>

</body>
</html>
