<?php
session_start();
include('../config/db_connect.php');

if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}

// Fetch students with class names
$query = "
    SELECT students.student_id, students.full_name, students.gender, classes.class_name
    FROM students
    INNER JOIN classes ON students.class_id = classes.class_id
    ORDER BY classes.class_name, students.full_name ASC
";
$result = mysqli_query($conn, $query);
$total_students = mysqli_num_rows($result);
?>

<!DOCTYPE html>
<html>
<head>
    <title>View Students</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: #f1f5f9;
        }

        .container {
            width: 90%;
            margin: 40px auto;
            background: white;
            padding: 25px;
            border-radius: 8px;
            box-shadow: 0px 0px 10px rgba(0,0,0,0.12);
        }

        h2 {
            text-align: center;
            color: #075d8a;
            margin-bottom: 18px;
        }

        .count {
            text-align: center;
            font-size: 16px;
            margin-bottom: 12px;
            color: #555;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th, td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            text-align: center;
        }

        th {
            background: #075d8a;
            color: white;
        }

        a.btn {
            padding: 6px 12px;
            border-radius: 5px;
            text-decoration: none;
            color: white;
            font-weight: bold;
        }

        .edit { background: #f4b400; }
        .delete { background: #d9534f; }

        .delete:hover { background: #b52b27; }
        .edit:hover { background: #d99a00; }

        .back {
            display: inline-block;
            margin-top: 25px;
            padding: 10px 18px;
            background: #075d8a;
            color: white;
            border-radius: 6px;
            text-decoration: none;
        }

        .back:hover { background: #0a9edb; }

        .empty {
            text-align: center;
            padding: 18px;
            color: #777;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>👨‍👩‍👦 Student List</h2>
    <div class="count">Total Students: <b><?php echo $total_students; ?></b></div>

    <?php if($total_students > 0) { ?>
    <table>
        <tr>
            <th>Full Name</th>
            <th>Gender</th>
            <th>Class</th>
            <th>Actions</th>
        </tr>

        <?php while($row = mysqli_fetch_assoc($result)) { ?>
            <tr>
                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                <td><?php echo htmlspecialchars($row['gender']); ?></td>
                <td><?php echo htmlspecialchars($row['class_name']); ?></td>
                <td>
                    <a class="btn edit" href="edit_student.php?id=<?php echo $row['student_id']; ?>">Edit</a>
                    <a class="btn delete" href="delete_student.php?id=<?php echo $row['student_id']; ?>" onclick="return confirm('Are you sure you want to delete this student?');">Delete</a>
                </td>
            </tr>
        <?php } ?>
    </table>

    <?php } else { ?>
        <p class="empty">No students found.</p>
    <?php } ?>

    <a class="back" href="dashboard.php">⬅ Back to Dashboard</a>
</div>

</body>
</html>
