<?php
session_start();
include('../config/db_connect.php');

if(!isset($_SESSION['admin'])){
    header("Location: index.php");
    exit;
}

if(!isset($_GET['id'])){
    header("Location: view_teachers.php");
    exit;
}

$teacher_id = $_GET['id'];

// Get teacher info
$teacher = mysqli_query($conn, "SELECT * FROM teachers WHERE teacher_id = '$teacher_id'");
$data = mysqli_fetch_assoc($teacher);

// Get classes
$classes = mysqli_query($conn, "SELECT * FROM classes ORDER BY class_name ASC");

$message = "";

if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $full_name = trim($_POST['full_name']);
    $username = trim($_POST['username']);
    $password = trim($_POST['password']); 
    $class_id = $_POST['class_id'];

    if(!empty($password)){
        // Update password only if field is filled
        $query = "UPDATE teachers 
                  SET full_name='$full_name', username='$username', password='$password', class_id='$class_id'
                  WHERE teacher_id='$teacher_id'";
    } else {
        $query = "UPDATE teachers 
                  SET full_name='$full_name', username='$username', class_id='$class_id'
                  WHERE teacher_id='$teacher_id'";
    }

    if(mysqli_query($conn, $query)){
        $message = "✅ Teacher updated successfully!";
    } else {
        $message = "❌ Error updating teacher!";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Teacher</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: #e9f4fb;
        }

        .container {
            width: 420px;
            margin: 50px auto;
            padding: 25px;
            background: white;
            border-radius: 10px;
            box-shadow: 0px 0px 12px rgba(0,0,0,0.12);
        }

        h2 {
            text-align: center;
            color: #075d8a;
        }

        input, select {
            width: 100%;
            padding: 10px;
            margin-top: 12px;
            border-radius: 6px;
            border: 1px solid #ccc;
        }

        button {
            width: 100%;
            padding: 10px;
            margin-top: 18px;
            border: none;
            background: #075d8a;
            color: white;
            border-radius: 6px;
            cursor: pointer;
            transition: 0.3s;
        }

        button:hover { background: #0a9edb; }

        .message { margin-top: 10px; text-align: center; font-weight: bold; }

        a.back {
            display: inline-block;
            margin-top: 18px;
            text-decoration: none;
            color: #075d8a;
            text-align: center;
            width: 100%;
        }

        a.back:hover { text-decoration: underline; }
    </style>
</head>
<body>

<div class="container">
    <h2>✏️ Edit Teacher</h2>

    <form method="POST">

        <input type="text" name="full_name" value="<?php echo $data['full_name']; ?>" required>

        <input type="text" name="username" value="<?php echo $data['username']; ?>" required>

        <input type="text" name="password" placeholder="Enter new password (optional)">

        <select name="class_id" required>
            <option value="">-- Select Class --</option>
            <?php while($row = mysqli_fetch_assoc($classes)){ ?>
                <option value="<?php echo $row['class_id']; ?>" 
                    <?php if($data['class_id'] == $row['class_id']) echo "selected"; ?>>
                    <?php echo $row['class_name']; ?>
                </option>
            <?php } ?>
        </select>

        <button type="submit">💾 Update</button>
    </form>

    <p class="message"><?php echo $message; ?></p>

    <a class="back" href="view_teachers.php">⬅ Back to Teacher List</a>
</div>

</body>
</html>
