<?php
// payroll_employees.php
session_start();
include('../config/db_connect.php');
if (!isset($_SESSION['admin'])) { header("Location: index.php"); exit; }

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_employee'])) {
    $num = trim($_POST['employee_number']);
    $name = trim($_POST['full_name']);
    $dept = trim($_POST['department']);
    $des = trim($_POST['designation']);
    $bank = trim($_POST['bank_name']);
    $acct = trim($_POST['bank_account']);
    $nrc = trim($_POST['nrc']);
    $hire = $_POST['hire_date'] ?: null;
    $basic = (float)($_POST['basic_salary'] ?: 0);

    $stmt = $conn->prepare("INSERT INTO employees (employee_number, full_name, department, designation, bank_name, bank_account, nrc, hire_date, basic_salary) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssssd", $num, $name, $dept, $des, $bank, $acct, $nrc, $hire, $basic);
    if ($stmt->execute()) $msg = "Employee added.";
    else $msg = "Error: " . $stmt->error;
    $stmt->close();
}

// Deletion
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $conn->query("DELETE FROM employees WHERE employee_id=$id");
    header("Location: payroll_employees.php");
    exit;
}

$emps = $conn->query("SELECT * FROM employees ORDER BY full_name ASC");
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Payroll — Employees</title>
  <style>
    body{font-family:Arial;margin:20px;background:#f6f7fb}
    .card{background:#fff;padding:18px;border-radius:8px;box-shadow:0 4px 12px rgba(0,0,0,0.06)}
    input,select{padding:8px;width:100%;margin:6px 0;border-radius:6px;border:1px solid #ddd}
    .btn{padding:8px 12px;background:#075d8a;color:#fff;border:none;border-radius:6px;cursor:pointer}
    table{width:100%;border-collapse:collapse;margin-top:14px}
    th,td{border:1px solid #e5e7eb;padding:8px;text-align:left}
  </style>
</head>
<body>
<div class="card">
  <h2>Employees — Payroll</h2>
  <?php if($msg) echo "<p style='color:green'>$msg</p>"; ?>
  <form method="post">
    <label>Employee Number</label><input name="employee_number" required>
    <label>Full Name</label><input name="full_name" required>
    <label>Department</label><input name="department">
    <label>Designation</label><input name="designation">
    <label>Bank Name</label><input name="bank_name">
    <label>Bank Account</label><input name="bank_account">
    <label>NAPSA / NRC</label><input name="nrc">
    <label>Hire Date</label><input type="date" name="hire_date">
    <label>Basic Salary (monthly)</label><input name="basic_salary" type="number" step="0.01" value="0">
    <button class="btn" name="add_employee" type="submit">Add Employee</button>
  </form>

  <h3>Existing Employees</h3>
  <table>
    <thead><tr><th>#</th><th>Name</th><th>Department</th><th>Basic</th><th>Actions</th></tr></thead>
    <tbody>
    <?php while($row = $emps->fetch_assoc()): ?>
      <tr>
        <td><?=htmlspecialchars($row['employee_number'])?></td>
        <td><?=htmlspecialchars($row['full_name'])?></td>
        <td><?=htmlspecialchars($row['department'])?></td>
        <td><?=number_format($row['basic_salary'],2)?></td>
        <td>
          <a href="payroll_run.php?employee_id=<?=$row['employee_id']?>">Generate Payslip</a> |
          <a href="payroll_employees.php?delete=<?=$row['employee_id']?>" onclick="return confirm('Delete employee? This will remove payroll records too.');">Delete</a>
        </td>
      </tr>
    <?php endwhile; ?>
    </tbody>
  </table>
</div>
</body>
</html>
