<?php
// payroll_run.php
session_start();
include('../config/db_connect.php');
if (!isset($_SESSION['admin'])) { header("Location: ../index.php"); exit; }

$employee_id = isset($_GET['employee_id']) ? (int)$_GET['employee_id'] : 0;
if (!$employee_id) { die("No employee selected"); }

$emp = mysqli_fetch_assoc($conn->query("SELECT * FROM employees WHERE employee_id=$employee_id LIMIT 1"));
if (!$emp) die("Employee not found.");

// load settings
$settings = include __DIR__ . '/payroll_settings.php';
$round = $settings['round_precision'] ?? 2;

$errors = '';
$success = '';

// Default month = current month
$pay_month = $_POST['pay_month'] ?? date('Y-m-01');

// process submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['calculate'])) {

    $basic = (float)$_POST['basic'];
    $housing = (float)$_POST['housing'];
    $transport = (float)$_POST['transport'];
    $other = (float)$_POST['other'];
    $overtime = (float)$_POST['overtime'];

    // gross
    $gross = $basic + $housing + $transport + $other + $overtime;

    // NAPSA employee & employer
    $napsa_emp = round($gross * ($settings['napsa_employee_percent']/100), $round);
    $napsa_er  = round($gross * ($settings['napsa_employer_percent']/100), $round);

    // NHIMA employee
    $nhima_emp = round($gross * ($settings['nhima_employee_percent']/100), $round);

    // PAYE calculation — simple progressive band computation
    $taxable = max(0, $gross - ($settings['personal_relief'] ?? 0)); // you might want other reliefs
    $remaining = $taxable;
    $paye = 0.0;
    foreach($settings['paye_bands'] as $band) {
        $min = (float)$band['min'];
        $max = is_null($band['max']) ? null : (float)$band['max'];
        $rate = (float)$band['rate']/100.0;

        if ($max === null) {
            if ($remaining > $min) {
                $amount = $remaining - $min;
                $paye += $amount * $rate;
            }
        } else {
            // band amount is portion between min and max
            $bandStart = $min;
            $bandEnd = $max;
            // compute taxable portion in this band
            $portion = max(0, min($bandEnd, $taxable) - $bandStart);
            if ($portion > 0) {
                $paye += $portion * $rate;
            }
        }
    }

    // subtract personal relief from PAYE if desired (some approaches do relief on tax payable)
    $paye = max(0, $paye - ($settings['personal_relief'] ?? 0));
    $paye = round($paye, $round);

    $total_deductions = $napsa_emp + $nhima_emp + $paye;
    $net = round($gross - $total_deductions, $round);

    // persist payroll record
    $stmt = $conn->prepare("INSERT INTO payrolls (employee_id, pay_month, basic, housing_allowance, transport_allowance, other_allowance, overtime, gross_pay, napsa_employee, napsa_employer, nhima_employee, paye, total_deductions, net_pay, generated_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param("isdddddddddddsi",
        $employee_id,
        $pay_month,
        $basic,
        $housing,
        $transport,
        $other,
        $overtime,
        $gross,
        $napsa_emp,
        $napsa_er,
        $nhima_emp,
        $paye,
        $total_deductions,
        $net,
        $_SESSION['admin'] // could be admin id, use username if stored
    );
    if ($stmt->execute()) {
        $payroll_id = $stmt->insert_id;
        $success = "Payroll saved. Payroll ID: $payroll_id";
        // fetch record for display
        $record_id = $payroll_id;
    } else {
        $errors = "DB error: " . $stmt->error;
    }
    $stmt->close();
}

// If there is a payroll_id passed (view existing), load it
if (isset($_GET['payroll_id']) && is_numeric($_GET['payroll_id'])) {
    $record_id = (int)$_GET['payroll_id'];
    $recQ = $conn->query("SELECT * FROM payrolls WHERE payroll_id = $record_id LIMIT 1");
    $rec = $recQ->fetch_assoc();
} elseif (isset($payroll_id)) {
    $recQ = $conn->query("SELECT * FROM payrolls WHERE payroll_id = $payroll_id LIMIT 1");
    $rec = $recQ->fetch_assoc();
} else {
    $rec = null;
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Generate Payslip - <?=$emp['full_name']?></title>
  <style>
    body{font-family:Arial;background:#f4f6fb;padding:20px}
    .wrap{max-width:900px;margin:auto}
    .card{background:#fff;padding:18px;border-radius:8px;box-shadow:0 6px 24px rgba(0,0,0,0.06)}
    label{font-weight:600;font-size:13px}
    input{padding:8px;border-radius:6px;border:1px solid #ddd;width:100%;margin:6px 0}
    .grid{display:grid;grid-template-columns:1fr 1fr;gap:12px}
    .btn{background:#075d8a;color:#fff;padding:8px 12px;border-radius:6px;border:none;cursor:pointer}
    .muted{color:#666;font-size:13px}
    .top-actions{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
    .payslip{border:1px solid #111;padding:14px;margin-top:14px}
    .two-col{display:flex;justify-content:space-between}
    .signature{border-top:1px solid #000;height:70px;width:30%;text-align:center;padding-top:6px}
  </style>
</head>
<body>
<div class="wrap">
  <div class="top-actions">
    <h2>Generate Payslip — <?=htmlspecialchars($emp['full_name'])?></h2>
    <a href="payroll_employees.php">← Back to Employees</a>
  </div>

  <div class="card">
    <?php if($errors) echo "<p style='color:#b00020'>$errors</p>"; ?>
    <?php if($success) echo "<p style='color:green'>$success</p>"; ?>

    <form method="post">
      <div style="display:flex;gap:12px">
        <div style="flex:1">
          <label>Pay Month</label>
          <input type="month" name="pay_month" value="<?=htmlspecialchars(date('Y-m', strtotime($pay_month)))?>">
        </div>
      </div>

      <h4 style="margin-top:12px">Earnings</h4>
      <div class="grid">
        <div>
          <label>Basic</label>
          <input type="number" step="0.01" name="basic" value="<?=htmlspecialchars($emp['basic_salary'] ?: 0)?>">
        </div>
        <div>
          <label>Housing Allowance</label>
          <input type="number" step="0.01" name="housing" value="0">
        </div>
        <div>
          <label>Transport Allowance</label>
          <input type="number" step="0.01" name="transport" value="0">
        </div>
        <div>
          <label>Other Allowance</label>
          <input type="number" step="0.01" name="other" value="0">
        </div>
        <div>
          <label>Overtime</label>
          <input type="number" step="0.01" name="overtime" value="0">
        </div>
      </div>

      <div style="margin-top:12px">
        <button class="btn" name="calculate" type="submit">Calculate & Save Payroll</button>
      </div>
    </form>

    <?php if($rec): 
      // show payslip
      $p= $rec;
      $pay_month_display = date('F Y', strtotime($p['pay_month']));
    ?>
      <div class="payslip" id="payslip">
        <div class="two-col">
          <div>
            <h3 style="margin:0">DIVINE PROVIDENCE CONVENT SCHOOL</h3>
            <div class="muted">P.O BOX 214, CHAWAMA - LUSAKA</div>
          </div>
          <div style="text-align:right">
            <div><strong>Payslip for: <?=htmlspecialchars($pay_month_display)?></strong></div>
            <div class="muted"><?=htmlspecialchars($emp['full_name'])?></div>
          </div>
        </div>

        <hr>

        <div style="display:flex;gap:18px">
          <div style="flex:1">
            <div><strong>Employee ID:</strong> <?=htmlspecialchars($emp['employee_number'])?></div>
            <div><strong>Department:</strong> <?=htmlspecialchars($emp['department'])?></div>
            <div><strong>Designation:</strong> <?=htmlspecialchars($emp['designation'])?></div>
          </div>
          <div style="flex:1">
            <div><strong>Bank:</strong> <?=htmlspecialchars($emp['bank_name'])?></div>
            <div><strong>Account:</strong> <?=htmlspecialchars($emp['bank_account'])?></div>
            <div><strong>Hire Date:</strong> <?=htmlspecialchars($emp['hire_date'])?></div>
          </div>
        </div>

        <h4 style="margin-top:12px">Earnings & Deductions</h4>
        <table style="width:100%;border-collapse:collapse">
          <thead>
            <tr style="background:#f7f9fb">
              <th style="text-align:left;padding:8px;border:1px solid #ddd">Description</th>
              <th style="padding:8px;border:1px solid #ddd">Amount (K)</th>
              <th style="text-align:left;padding:8px;border:1px solid #ddd">Deduction</th>
              <th style="padding:8px;border:1px solid #ddd">Amount (K)</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="padding:8px;border:1px solid #ddd">Basic Salary</td>
              <td style="padding:8px;border:1px solid #ddd"><?=number_format($p['basic'],2)?></td>
              <td style="padding:8px;border:1px solid #ddd">NAPSA (employee)</td>
              <td style="padding:8px;border:1px solid #ddd"><?=number_format($p['napsa_employee'],2)?></td>
            </tr>
            <tr>
              <td style="padding:8px;border:1px solid #ddd">Housing Allowance</td>
              <td style="padding:8px;border:1px solid #ddd"><?=number_format($p['housing_allowance'],2)?></td>
              <td style="padding:8px;border:1px solid #ddd">NHIMA (employee)</td>
              <td style="padding:8px;border:1px solid #ddd"><?=number_format($p['nhima_employee'],2)?></td>
            </tr>
            <tr>
              <td style="padding:8px;border:1px solid #ddd">Transport Allowance</td>
              <td style="padding:8px;border:1px solid #ddd"><?=number_format($p['transport_allowance'],2)?></td>
              <td style="padding:8px;border:1px solid #ddd">PAYE</td>
              <td style="padding:8px;border:1px solid #ddd"><?=number_format($p['paye'],2)?></td>
            </tr>
            <tr>
              <td style="padding:8px;border:1px solid #ddd">Other Allowance</td>
              <td style="padding:8px;border:1px solid #ddd"><?=number_format($p['other_allowance'],2)?></td>
              <td style="padding:8px;border:1px solid #ddd">Total Deductions</td>
              <td style="padding:8px;border:1px solid #ddd"><?=number_format($p['total_deductions'],2)?></td>
            </tr>
            <tr>
              <td style="padding:8px;border:1px solid #ddd">Overtime</td>
              <td style="padding:8px;border:1px solid #ddd"><?=number_format($p['overtime'],2)?></td>
              <td style="padding:8px;border:1px solid #ddd"></td>
              <td style="padding:8px;border:1px solid #ddd"></td>
            </tr>
            <tr>
              <td style="padding:8px;border:1px solid #ddd"><strong>Gross Pay</strong></td>
              <td style="padding:8px;border:1px solid #ddd"><strong><?=number_format($p['gross_pay'],2)?></strong></td>
              <td style="padding:8px;border:1px solid #ddd"><strong>Net Pay</strong></td>
              <td style="padding:8px;border:1px solid #ddd"><strong><?=number_format($p['net_pay'],2)?></strong></td>
            </tr>
          </tbody>
        </table>

        <div style="display:flex;justify-content:space-between;margin-top:18px">
          <div class="signature">Class Teacher<br><small><?=htmlspecialchars($_SESSION['admin'] ?? '')?></small></div>
          <div class="signature">Payroll Officer<br><small>Finance</small></div>
          <div class="signature">Employee<br><small><?=htmlspecialchars($emp['full_name'])?></small></div>
        </div>

        <div style="text-align:right;margin-top:12px">
          <a href="payslip_pdf.php?payroll_id=<?=$p['payroll_id']?>" target="_blank" class="btn">Download PDF</a>
          <button onclick="window.print()" class="btn" style="background:#28a745">Print</button>
        </div>
      </div>
    <?php endif; ?>
  </div>
</div>
</body>
</html>
