<?php
// payroll_settings.php
// Central place to control payroll rates and PAYE bands

return [
    // NAPSA: example: employee 5% + employer 5% = 10% total
    'napsa_employee_percent' => 5.0,    // percent of gross that employee contributes
    'napsa_employer_percent' => 5.0,    // percent employer contributes (stored for info)

    // NHIMA / National Health Insurance - example default (edit to match your law)
    'nhima_employee_percent' => 1.5,    // percent employee contributes

    // PAYE bands — monthly thresholds and rates.
    // This array is ordered from lowest threshold (exclusive) to highest.
    // Format: [ ['min'=>X, 'max'=>Y, 'rate'=>R], ... ]
    // 'min' and 'max' inclusive/exclusive logic below uses: taxable amount between min+1 and max inclusive
    'paye_bands' => [
        // Example bands (edit to match current ZRA tables)
        ['min' => 0.00,   'max' => 5100.00,  'rate' => 0.0],   // 0% up to 5100
        ['min' => 5100.00,'max' => 7100.00,  'rate' => 20.0],  // 20% band
        ['min' => 7100.00,'max' => 9200.00,  'rate' => 30.0],  // 30% band
        ['min' => 9200.00,'max' => null,     'rate' => 37.0],  // 37% above
    ],

    // Personal relief (monthly); adjust to official number or set to 0
    'personal_relief' => 0.00, // subtract from tax payable

    // Option to round numbers when showing payslip
    'round_precision' => 2,
];
