<?php
// payslip_pdf.php
session_start();
include('../config/db_connect.php');
if (!isset($_SESSION['admin'])) { header("Location: ../index.php"); exit; }

if (!isset($_GET['payroll_id'])) die("Payroll id required");
$payroll_id = (int)$_GET['payroll_id'];

// fetch payroll
$recQ = $conn->query("SELECT p.*, e.full_name, e.employee_number, e.department, e.designation, e.bank_name, e.bank_account FROM payrolls p LEFT JOIN employees e ON p.employee_id = e.employee_id WHERE p.payroll_id = $payroll_id LIMIT 1");
$rec = $recQ->fetch_assoc();
if (!$rec) die("Payroll not found.");

// simple html for pdf (same as earlier)
$pay_month_display = date('F Y', strtotime($rec['pay_month']));
$html = '<html><head><meta charset="utf-8"><style>
body{font-family: Arial; font-size:12px}
.header{display:flex;justify-content:space-between}
.table{width:100%;border-collapse:collapse;margin-top:10px}
.table th,.table td{border:1px solid #000;padding:6px}
.signature{border-top:1px solid #000;height:60px;text-align:center;padding-top:6px;margin-top:16px}
</style></head><body>';
$html .= '<div class="header"><div><h3>DIVINE PROVIDENCE CONVENT SCHOOL</h3><div>P.O BOX 214, CHAWAMA - LUSAKA</div></div><div style="text-align:right"><strong>Payslip: '.htmlspecialchars($pay_month_display).'</strong></div></div>';
$html .= '<h4>Employee: '.htmlspecialchars($rec['full_name']).' ('.htmlspecialchars($rec['employee_number']).')</h4>';
$html .= '<table class="table"><tr><th>Description</th><th>Amount (K)</th><th>Description</th><th>Amount (K)</th></tr>';
$html .= '<tr><td>Basic</td><td>'.number_format($rec['basic'],2).'</td><td>NAPSA (employee)</td><td>'.number_format($rec['napsa_employee'],2).'</td></tr>';
$html .= '<tr><td>Housing</td><td>'.number_format($rec['housing_allowance'],2).'</td><td>NHIMA (employee)</td><td>'.number_format($rec['nhima_employee'],2).'</td></tr>';
$html .= '<tr><td>Transport</td><td>'.number_format($rec['transport_allowance'],2).'</td><td>PAYE</td><td>'.number_format($rec['paye'],2).'</td></tr>';
$html .= '<tr><td>Other</td><td>'.number_format($rec['other_allowance'],2).'</td><td>Total Deductions</td><td>'.number_format($rec['total_deductions'],2).'</td></tr>';
$html .= '<tr><td>Overtime</td><td>'.number_format($rec['overtime'],2).'</td><td><strong>Net Pay</strong></td><td><strong>'.number_format($rec['net_pay'],2).'</strong></td></tr>';
$html .= '</table>';
$html .= '<div style="display:flex;justify-content:space-between;margin-top:20px"><div class="signature">Employer</div><div class="signature">Payroll Officer</div><div class="signature">Employee</div></div>';
$html .= '</body></html>';

// try to generate PDF
if (!file_exists(__DIR__ . '/../vendor/autoload.php')) {
    echo "Dompdf not installed. Install with composer require dompdf/dompdf to enable PDF generation. Or print as HTML from the payslip page.";
    exit;
}

require __DIR__ . '/../vendor/autoload.php';
use Dompdf\Dompdf;
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("payslip_{$payroll_id}.pdf", ["Attachment" => true]);
