<?php
session_start();
include('../config/db_connect.php');

if (!isset($_SESSION['admin'])) {
    header("Location: index.php");
    exit;
}

// Fetch HODs with department names
$query = "
    SELECT h.hod_id, h.full_name, h.username, h.password, d.dept_name
    FROM hods h
    LEFT JOIN departments d ON h.dept_id = d.dept_id
    ORDER BY h.hod_id DESC
";

$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html>
<head>
<title>View HODs</title>
<style>
    body {
        margin: 0;
        font-family: Poppins, sans-serif;
        background: #0a6fb6;
        color: white;
        padding: 30px;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 25px;
        background: rgba(255,255,255,0.15);
        backdrop-filter: blur(8px);
        color: white;
    }
    th, td {
        padding: 12px;
        border-bottom: 1px solid rgba(255,255,255,0.2);
        text-align: left;
    }
    th {
        background: rgba(0,0,0,0.3);
        font-weight: bold;
    }
    .btn-delete {
        color: white;
        background: red;
        padding: 6px 12px;
        border-radius: 6px;
        text-decoration: none;
        font-size: 14px;
    }
    .btn-delete:hover {
        background: darkred;
    }
</style>
</head>

<body>

<h2>All HODs</h2>

<table>
    <tr>
        <th>ID</th>
        <th>Full Name</th>
        <th>Username</th>
        <th>Password</th>
        <th>Department</th>
        <th>Action</th>
    </tr>

    <?php while ($row = mysqli_fetch_assoc($result)) { ?>
        <tr>
            <td><?= $row['hod_id']; ?></td>
            <td><?= $row['full_name']; ?></td>
            <td><?= $row['username']; ?></td>
            <td><?= $row['password']; ?></td>
            <td><?= $row['dept_name'] ?? 'Not Assigned'; ?></td>

            <td>
                <a class="btn-delete" 
                   href="delete_hod.php?hod_id=<?= $row['hod_id']; ?>"
                   onclick="return confirm('Are you sure you want to delete this HOD?');">
                    Delete
                </a>
            </td>
        </tr>
    <?php } ?>

</table>

<br>
<a href="dashboard.php" style="color:white;">⬅ Back to Dashboard</a>

</body>
</html>
