<?php
// hod/hod_login.php
session_start();
include('../config/db_connect.php');

$message = "";

// If session expired redirect message
if (isset($_GET['timeout'])) {
    $message = "Session expired. Please login again.";
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if ($username === '' || $password === '') {
        $message = "Enter username and password.";
    } else {

        $stmt = $conn->prepare("
            SELECT hod_id, full_name, dept_id, username, password 
            FROM hods 
            WHERE username = ? 
            LIMIT 1
        ");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $res = $stmt->get_result();

        if ($res && $res->num_rows === 1) {

            $hod = $res->fetch_assoc();

            // Plain text password match (as your system currently uses)
            if ($password === $hod['password']) {

                session_regenerate_id(true);

                $_SESSION['hod_id']   = $hod['hod_id'];
                $_SESSION['hod_name'] = $hod['full_name'];
                $_SESSION['hod_dept'] = $hod['dept_id'];
                $_SESSION['last_activity'] = time();
                $_SESSION['regenerated_time'] = time();

                header("Location: hod_dashboard.php");
                exit;
            } 
            else {
                $message = "Invalid credentials.";
            }

        } else {
            $message = "Invalid credentials.";
        }

        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>HOD Login</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f0f2f5;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .card {
            background: #fff;
            padding: 35px;
            border-radius: 12px;
            width: 380px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
            text-align: center;
        }

        h3 {
            margin-bottom: 20px;
            font-size: 22px;
            font-weight: 600;
            color: #333;
        }

        .form-row {
            margin-bottom: 18px;
            text-align: left;
        }

        label {
            display: block;
            font-weight: 600;
            margin-bottom: 6px;
            color: #333;
        }

        input[type="text"], input[type="password"] {
            width: 100%;
            padding: 12px;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 15px;
        }

        input:focus {
            border-color: #007bff;
            outline: none;
        }

        .btn {
            width: 100%;
            padding: 12px;
            background: #007bff;
            color: #fff;
            font-weight: bold;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }

        .btn:hover {
            background: #0056b3;
        }

        .note {
            margin-top: 20px;
            font-size: 14px;
        }

        .note a {
            text-decoration: none;
            color: #007bff;
        }

        .error-message {
            color: #b00020;
            font-size: 14px;
            margin-bottom: 15px;
        }
    </style>

</head>
<body>

<div class="card">

    <h3>HOD Portal Login</h3>

    <?php if ($message): ?>
        <p class="error-message"><?php echo htmlspecialchars($message); ?></p>
    <?php endif; ?>

    <form method="post" autocomplete="off">
        <div class="form-row">
            <label>Username</label>
            <input type="text" name="username" required>
        </div>

        <div class="form-row">
            <label>Password</label>
            <input type="password" name="password" required>
        </div>

        <button class="btn" type="submit">Login</button>
    </form>

    <p class="note">
        <a href="../index.php">Back to Home</a>
    </p>

</div>

</body>
</html>
