// Mobile nav toggle
document.addEventListener('DOMContentLoaded', function(){
  function hook(toggleId, navId){
    var t = document.getElementById(toggleId);
    var nav = document.querySelector('.main-nav');
    if(!t || !nav) return;
    t.addEventListener('click', function(){
      nav.classList.toggle('open');
      if(nav.classList.contains('open')){
        nav.style.display = 'flex';
        nav.style.flexDirection = 'column';
        nav.style.gap = '10px';
      } else {
        nav.style.display = '';
      }
    });
  }
  hook('nav-toggle','main-nav'); // primary
  hook('nav-toggle-2','main-nav-2');
  hook('nav-toggle-3','main-nav-3');
});
