<?php
session_start();
include('../config/db_connect.php');

if(!isset($_SESSION['teacher_id'])){
    header("Location: index.php");
    exit;
}

$class_id = $_SESSION['class_id'];
$term = isset($_POST['term']) ? $_POST['term'] : "Term 1";

// Fetch Students
$students = mysqli_query($conn, "SELECT * FROM students WHERE class_id='$class_id' ORDER BY full_name ASC");

// Fetch Subjects
$subjects = mysqli_query($conn, "SELECT * FROM subjects WHERE class_id='$class_id' ORDER BY subject_name ASC");

// Save Marks
if(isset($_POST['save'])){
    foreach($_POST['marks'] as $student_id => $subject_marks){
        foreach($subject_marks as $subject_id => $mark){
            
            $mark = ($mark === "" ? null : (int)$mark);

            // Check if mark exists
            $check = mysqli_query($conn, "SELECT * FROM marks 
                WHERE student_id='$student_id' AND subject_id='$subject_id' AND term='$term'");

            if(mysqli_num_rows($check) > 0){
                mysqli_query($conn, "UPDATE marks SET mark='$mark' 
                WHERE student_id='$student_id' AND subject_id='$subject_id' AND term='$term'");
            } else {
                mysqli_query($conn, "INSERT INTO marks (student_id, subject_id, term, mark, class_id)
                VALUES ('$student_id', '$subject_id', '$term', '$mark', '$class_id')");
            }
        }
    }

    // Calculate Average per Student
    $subject_count = mysqli_num_rows($subjects);
    mysqli_data_seek($students, 0);

    while($stu = mysqli_fetch_assoc($students)){
        $sid = $stu['student_id'];

        $totalQ = mysqli_query($conn, "SELECT SUM(mark) AS total FROM marks 
            WHERE student_id='$sid' AND term='$term'");
        $total = mysqli_fetch_assoc($totalQ)['total'];

        $avg = ($subject_count > 0 && $total > 0) ? ($total / $subject_count) : 0;

        mysqli_query($conn, "UPDATE marks SET average='$avg' 
        WHERE student_id='$sid' AND term='$term'");
    }

    // Ranking System
    $rankQ = mysqli_query($conn, "
        SELECT student_id, AVG(mark) AS avg_mark 
        FROM marks 
        WHERE class_id='$class_id' AND term='$term'
        GROUP BY student_id
        ORDER BY avg_mark DESC
    ");

    $rank = 1;
    while($row = mysqli_fetch_assoc($rankQ)){
        $sid = $row['student_id'];
        mysqli_query($conn, "UPDATE marks SET rank_position='$rank'
        WHERE student_id='$sid' AND term='$term'");
        $rank++;
    }

    echo "<script>alert('✅ Marks Saved Successfully!');</script>";
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Enter Marks</title>
<style>
body{
    font-family: Arial;
    background: #f4f7fb;
}
.container{
    width: 95%;
    margin: auto;
    margin-top: 20px;
}
table{
    border-collapse: collapse;
    width: 100%;
    background: white;
}
th, td{
    border: 1px solid #555;
    padding: 8px;
    text-align: center;
}
th{
    background: #0a4c75;
    color: white;
}
input{
    width: 60px;
    padding: 6px;
    text-align: center;
}
button{
    padding: 10px 18px;
    background: #075d8a;
    color: #fff;
    border: none;
    border-radius: 5px;
    cursor: pointer;
}
button:hover{
    background:#043d5c;
}
</style>
</head>
<body>

<div class="container">

<h2>Enter Marks</h2>

<form method="POST">

<label><b>Select Term:</b></label>
<select name="term" onchange="this.form.submit()">
    <option value="Term 1" <?php if($term=="Term 1") echo "selected"; ?>>Term 1</option>
    <option value="Term 2" <?php if($term=="Term 2") echo "selected"; ?>>Term 2</option>
    <option value="Term 3" <?php if($term=="Term 3") echo "selected"; ?>>Term 3</option>
</select>

<br><br>

<table>
    <tr>
        <th>NAME</th>
        <?php mysqli_data_seek($subjects, 0);
        while($sub = mysqli_fetch_assoc($subjects)){ ?>
            <th><?php echo strtoupper($sub['subject_name']); ?></th>
        <?php } ?>
        <th>AVERAGE</th>
        <th>RANK</th>
    </tr>

    <?php mysqli_data_seek($students, 0);
    while($stu = mysqli_fetch_assoc($students)){ 
        $sid = $stu['student_id']; ?>
        <tr>
            <td><?php echo $stu['full_name']; ?></td>

            <?php mysqli_data_seek($subjects, 0);
            while($sub = mysqli_fetch_assoc($subjects)){
                $subid = $sub['subject_id'];
                $ex = mysqli_query($conn, "SELECT mark, average, rank_position FROM marks 
                    WHERE student_id='$sid' AND subject_id='$subid' AND term='$term'");
                $row = mysqli_fetch_assoc($ex);
                $value = $row['mark'] ?? '';
                ?>
                <td><input type="number" name="marks[<?php echo $sid; ?>][<?php echo $subid; ?>]" value="<?php echo $value; ?>"></td>
            <?php } ?>

            <?php 
            $stat = mysqli_query($conn, "SELECT average, rank_position FROM marks 
                WHERE student_id='$sid' AND term='$term' LIMIT 1");
            $st = mysqli_fetch_assoc($stat);
            ?>
            <td><?php echo isset($st['average']) ? number_format($st['average'],1) : '0'; ?></td>
            <td><?php echo $st['rank_position'] ?? '-'; ?></td>
        </tr>
    <?php } ?>
</table>

<br>
<button type="submit" name="save">Save Marks</button>

</form>

<br>
<a href="dashboard.php">⬅ Back to Dashboard</a>

</div>
<script>
function updateMarks() {
    let table = document.querySelector("table");
    let rows = table.querySelectorAll("tr:not(:first-child)"); // skip header row

    let rankingData = [];

    rows.forEach(row => {
        let inputs = row.querySelectorAll("input[type=number]");
        let total = 0;
        let count = 0;

        inputs.forEach(input => {
            let value = parseFloat(input.value);
            if (!isNaN(value)) {
                total += value;
                count++;
            }
        });

        // Calculate average
        let avg = (count > 0) ? (total / count) : 0;
        row.querySelector(".avg_cell").innerText = avg.toFixed(1);

        rankingData.push({ row: row, avg: avg });
    });

    // Rank students by average (DESC)
    rankingData.sort((a, b) => b.avg - a.avg);

    let rank = 1;
    rankingData.forEach(entry => {
        entry.row.querySelector(".rank_cell").innerText = rank;
        rank++;
    });
}

// Trigger instant calculation during typing
document.querySelectorAll("input[type=number]").forEach(input => {
    input.addEventListener("input", updateMarks);
});

// Run once when page loads
updateMarks();
</script>


</body>
</html>
