<?php
session_start();
include('../config/db_connect.php');

// Ensure teacher is logged in
if (!isset($_SESSION['teacher_id'])) {
    header("Location: index.php");
    exit;
}

$class_id = $_SESSION['class_id']; // Teacher can manage ONLY their class

/* ============================
   ADD SINGLE STUDENT
================================ */
if (isset($_POST['add_single'])) {

    $name   = trim($_POST['full_name']);
    $gender = trim($_POST['gender']);

    $stmt = $conn->prepare("INSERT INTO students (full_name, gender, class_id) VALUES (?, ?, ?)");
    $stmt->bind_param("ssi", $name, $gender, $class_id);
    $stmt->execute();

    echo "<script>alert('✅ Student Added Successfully!'); window.location='manage_students.php';</script>";
    exit;
}

/* ============================
   DELETE SINGLE STUDENT
   (marks auto-delete via ON DELETE CASCADE)
================================ */
if (isset($_GET['delete'])) {

    $sid = intval($_GET['delete']);

    $stmt = $conn->prepare("DELETE FROM students WHERE student_id = ? AND class_id = ?");
    $stmt->bind_param("ii", $sid, $class_id);
    $stmt->execute();

    echo "<script>alert('🗑️ Student Removed!'); window.location='manage_students.php';</script>";
    exit;
}

/* ============================
   BULK DELETE SELECTED STUDENTS
================================ */
if (isset($_POST['delete_selected']) && isset($_POST['student_ids'])) {
    
    $ids = $_POST['student_ids'];  // array

    foreach ($ids as $sid) {
        $sid = intval($sid);

        $stmt = $conn->prepare("DELETE FROM students WHERE student_id = ? AND class_id = ?");
        $stmt->bind_param("ii", $sid, $class_id);
        $stmt->execute();
    }

    echo "<script>alert('✅ Selected Students Deleted Successfully!'); window.location='manage_students.php';</script>";
    exit;
}

/* ============================
   FETCH STUDENTS
================================ */
$stmt = $conn->prepare("SELECT * FROM students WHERE class_id = ? ORDER BY full_name ASC");
$stmt->bind_param("i", $class_id);
$stmt->execute();
$students = $stmt->get_result();

?>
<!DOCTYPE html>
<html>
<head>
    <title>Manage Students</title>
    <style>
        body { font-family: Arial; background:#f1f5f9; }
        .container { width: 90%; margin: auto; margin-top: 30px; }

        table { border-collapse: collapse; width: 100%; background:white; margin-top:20px; }
        th, td { border: 1px solid #bbb; padding: 10px; text-align: center; }
        th { background: #075d8a; color: white; }

        input[type="text"], select, button {
            padding: 8px;
            width: 100%;
            margin-top: 5px;
        }

        .upload-link {
            float: right; 
            padding: 8px 12px; 
            background: #0078ff;
            color:white; 
            text-decoration:none; 
            border-radius:5px;
        }
        .upload-link:hover { background:#005fcc; }

        .bulk-delete {
            margin-top: 15px;
            background:#d9534f;
            color:white;
            border:none;
            padding:10px 15px;
            cursor:pointer;
            border-radius:5px;
        }
        .bulk-delete:hover { background:#b52b27; }

        .form-box {
            margin-top:20px;
            border:1px solid #ccc;
            background:white;
            padding:15px;
            width:40%;
        }

        .back {
            margin-top:20px;
            display:inline-block;
            padding:10px 15px;
            background:#075d8a;
            color:white;
            border-radius:6px;
            text-decoration:none;
        }
        .back:hover { background:#0a9edb; }
    </style>
</head>
<body>

<div class="container">

    <a href="upload_students.php" class="upload-link">📁 Upload CSV Students</a>
    <h2>👨‍🎓 Manage Class Students</h2>

    <form method="POST">
        <table>
            <tr>
                <th>Select</th>
                <th>#</th>
                <th>Full Name</th>
                <th>Gender</th>
                <th>Action</th>
            </tr>

            <?php 
            $i = 1;
            while ($row = $students->fetch_assoc()) { ?>
            <tr>
                <td>
                    <input type="checkbox" name="student_ids[]" value="<?= $row['student_id']; ?>">
                </td>
                <td><?= $i++; ?></td>
                <td><?= htmlspecialchars($row['full_name']); ?></td>
                <td><?= htmlspecialchars($row['gender']); ?></td>
                <td>
                    <a href="?delete=<?= $row['student_id']; ?>" 
                       onclick="return confirm('Remove this student?');">
                       ❌ Remove
                    </a>
                </td>
            </tr>
            <?php } ?>
        </table>

        <button type="submit" name="delete_selected" class="bulk-delete"
                onclick="return confirm('Delete selected students?');">
            🗑️ Delete Selected Students
        </button>
    </form>

    <div class="form-box">
        <h3>➕ Add Single Student</h3>
        <form method="POST">
            <label>Full Name:</label>
            <input type="text" name="full_name" required>

            <label>Gender:</label>
            <select name="gender" required>
                <option value="">-- Select Gender --</option>
                <option value="Male">Male</option>
                <option value="Female">Female</option>
            </select>

            <button type="submit" name="add_single">Add Student</button>
        </form>
    </div>

    <br><br>
    <a href="dashboard.php" class="back">⬅ Back to Dashboard</a>

</div>

</body>
</html>
