<?php
session_start();
include('../config/db_connect.php');

if(!isset($_SESSION['teacher_id'])){
    header("Location: index.php");
    exit;
}

$class_id = $_SESSION['class_id'];

if(isset($_POST['upload'])){
    if(isset($_FILES['csv_file']) && $_FILES['csv_file']['error'] == 0){

        $file = fopen($_FILES['csv_file']['tmp_name'], "r");

        // Skip the header row
        fgetcsv($file);

        $count = 0;

        while(($row = fgetcsv($file, 1000, ",")) !== FALSE){
            $full_name = mysqli_real_escape_string($conn, $row[0]);
            $gender = mysqli_real_escape_string($conn, strtoupper($row[1])); // ensure M/F

            // Insert student into this teacher's class only
            mysqli_query($conn, "INSERT INTO students (full_name, gender, class_id)
                                 VALUES ('$full_name', '$gender', '$class_id')");
            $count++;
        }

        fclose($file);

        echo "<script>alert('$count Students Successfully Uploaded ✅'); window.location='manage_students.php';</script>";
        exit;
    } else {
        echo "<script>alert('Please select a valid CSV file.');</script>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Upload Students CSV</title>
    <style>
        body { font-family: Arial; }
        .container { width: 50%; margin: auto; margin-top: 50px; border:1px solid #ccc; padding:20px; }
        input, button { padding: 8px; width:100%; }
        button { cursor: pointer; background:#0078ff; color:#fff; border:none; }
        button:hover { background:#005fcc; }
        a { display:block; margin-top:20px; }
    </style>
</head>
<body>

<div class="container">
    <h2>📁 Upload Students CSV</h2>
    <p><b>CSV Format Example:</b></p>
    <pre>full_name,gender
John Banda,M
Mary Phiri,F</pre>

    <form method="POST" enctype="multipart/form-data">
        <label>Select CSV File:</label><br>
        <input type="file" name="csv_file" accept=".csv" required><br><br>

        <button type="submit" name="upload">Upload</button>
    </form>

    <a href="manage_students.php">⬅ Back</a>
</div>

</body>
</html>
